const navToggler = document.querySelector("nav button");

navToggler.addEventListener("click", function () {
  const navigation = this.closest(".toggling-navigation");

  navigation.classList.toggle("active");
});

const svgs = document.querySelectorAll("svg");

svgs.forEach((svg) => {
  const animatablePaths = Array.from(svg.querySelectorAll("path"));
  const animatableCircles = Array.from(svg.querySelectorAll("circle"));

  const animatables = [...animatablePaths, ...animatableCircles];

  animatables.forEach((animatable) => {
    const totalLength = animatable.getTotalLength();

    animatable.style.setProperty("--thisLength", totalLength);
  });
});